#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_BloodProductModifications : BaseTest 
	{
		private char _pm1  = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.SplitAdult);
		private char _pm3  = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.Deglycerolized);
		private char _pm4  = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.Frozen);
		private char _pm5  = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.Irradiated);
		private char _pm6  = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.LeukoReduced);
		private char _pm7  = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.Pooled);
		private char _pm8  = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.Rejuvenated);
		private char _pm9  = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.Thawed);
		private char _pm10 = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.VolumeReduced);
		private char _pm11 = Common.Utility.GetProductModificationCharFromEnum(Common.ProductModification.Washed);

		private DataTable _dtProdMods;
		

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtProdMods = UnitTestUtil.RunSQLGetDataTable(" SELECT * FROM ProductModificationParameter WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", false);
				//ProductModificationParameter all start out inactive, so activate some
				if (this._dtProdMods.Rows.Count == 0)
				{
					UnitTestUtil.RunSQL("UPDATE ProductModificationParameter SET RecordStatusCode = 'A', ProductModificationCost = 3 WHERE RecordStatusCode = 'X' AND DivisionCode ='" + this.TestDivisionCode + "'");
					this._dtProdMods = UnitTestUtil.RunSQLGetDataTable(" SELECT * FROM ProductModificationParameter WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);
				}
				this.RefreshData = false;

			}
		}

		[Test]
		public void Ctor_Blank_Pass()
		{
			BOL.BloodProductModifications tmpObj = new BOL.BloodProductModifications();
			Assert.IsTrue(tmpObj.ProductModifications.Count == 0);
			Assert.IsTrue(tmpObj.ModificationCosts.Count == 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Blank_Fail()
		{
		}

		[Test]
		public void Ctor_String_Pass()
		{
			BOL.BloodProductModifications tmpObj = new BOL.BloodProductModifications(UnitTestConfig.TestDivisionCode);

			Assert.AreEqual(11, tmpObj.ProductModifications.Count, "Modifications.Count");
			Assert.AreEqual(11, tmpObj.ModificationCosts.Count, "Costs.Count");

			foreach (DataRow dr in this._dtProdMods.Rows)
			{
				char modCode = dr[TABLES.ProductModificationParameter.ProductModificationCode].ToString()[0];
				decimal modCost = (decimal)dr[TABLES.ProductModificationParameter.ProductModificationCost];

				Assert.AreEqual(modCost, (decimal)tmpObj.ModificationCosts[modCode], "Cost-[" + modCode.ToString() + "]");
			}
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_String_Fail()
		{
		}

		[Test]
		public void ProductModifications_Pass()
		{
			Hashtable tmpValue = new Hashtable();
			tmpValue.Add("TestKey", "TestValue");

			BOL.BloodProductModifications tmpObj = new BOL.BloodProductModifications();

			tmpObj.ProductModifications = tmpValue;
			Assert.IsTrue(tmpObj.ProductModifications.Count == 1);
			Assert.IsTrue(tmpObj.ProductModifications.ContainsKey("TestKey"));
			Assert.IsTrue(tmpObj.ProductModifications.ContainsValue("TestValue"));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ProductModifications_Fail()
		{
		}

		[Test]
		public void ModificationCosts_Pass()
		{
			Hashtable tmpValue = new Hashtable();
			tmpValue.Add("TestKey", "TestValue");

			BOL.BloodProductModifications tmpObj = new BOL.BloodProductModifications();

			tmpObj.ModificationCosts = tmpValue;
			Assert.IsTrue(tmpObj.ModificationCosts.Count == 1);
			Assert.IsTrue(tmpObj.ModificationCosts.ContainsKey("TestKey"));
			Assert.IsTrue(tmpObj.ModificationCosts.ContainsValue("TestValue"));
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ModificationCosts_Fail()
		{
		}
		
		[Test]
		public void UpdateProductModifications_Pass()
		{
			BOL.BloodProductModifications tmpObj = new BOL.BloodProductModifications(UnitTestConfig.TestDivisionCode);

			Hashtable htBefore = tmpObj.ModificationCosts;

			htBefore[this._pm1] = (decimal)1;
			htBefore[this._pm3] = (decimal)3;
			htBefore[this._pm4] = (decimal)4;
			htBefore[this._pm5] = (decimal)5;
			htBefore[this._pm6] = (decimal)6;
			htBefore[this._pm7] = (decimal)7;
			htBefore[this._pm8] = (decimal)8;
			htBefore[this._pm9] = (decimal)9;
			htBefore[this._pm10] = (decimal)10;
			htBefore[this._pm11] = (decimal)11;

			tmpObj.ModificationCosts = htBefore;

			tmpObj.UpdateProductModifications(UnitTestConfig.TestDivisionCode, Common.UpdateFunction.UnitTests);

			BOL.BloodProductModifications tmpObj2 = new BOL.BloodProductModifications(UnitTestConfig.TestDivisionCode);
			Hashtable htAfter = tmpObj2.ModificationCosts;

			Assert.IsTrue((decimal)htBefore[this._pm1] == (decimal)htAfter[this._pm1]);
			Assert.IsTrue((decimal)htBefore[this._pm3] == (decimal)htAfter[this._pm3]);
			Assert.IsTrue((decimal)htBefore[this._pm4] == (decimal)htAfter[this._pm4]);
			Assert.IsTrue((decimal)htBefore[this._pm5] == (decimal)htAfter[this._pm5]);
			Assert.IsTrue((decimal)htBefore[this._pm6] == (decimal)htAfter[this._pm6]);
			Assert.IsTrue((decimal)htBefore[this._pm7] == (decimal)htAfter[this._pm7]);
			Assert.IsTrue((decimal)htBefore[this._pm8] == (decimal)htAfter[this._pm8]);
			Assert.IsTrue((decimal)htBefore[this._pm9] == (decimal)htAfter[this._pm9]);
			Assert.IsTrue((decimal)htBefore[this._pm10] == (decimal)htAfter[this._pm10]);
			Assert.IsTrue((decimal)htBefore[this._pm11] == (decimal)htAfter[this._pm11]);

			//This will refresh our form level datatable
			this.RefreshData = true;
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void UpdateProductModifications_Fail()
		{
		}
		[Test]
		public void GetModificationStatus_Pass()
		{
			string updateModification = "Update ProductModificationParameter set RecordStatusCode = 'A' where ProductModificationCode = 'I' and DivisionCode = '589'";
			UnitTestUtil.RunSQL(updateModification);
			BOL.BloodProductModifications tmpObj = new BOL.BloodProductModifications("589");
			Assert.IsNotNull(tmpObj.GetModificationStatus(Common.ProductModification.Irradiated) == true);
		}
		[Test]
		public void GetModificationStatus_Fail()
		{
			string updateModification = "Update ProductModificationParameter set RecordStatusCode = 'X' where ProductModificationCode = 'I' and DivisionCode = '589'";
			UnitTestUtil.RunSQL(updateModification);
			BOL.BloodProductModifications tmpObj = new BOL.BloodProductModifications("589");
			Assert.IsNotNull(tmpObj.GetModificationStatus(Common.ProductModification.Irradiated) == true);
		}


		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			BOL.BloodProductModifications tmpObj = new BOL.BloodProductModifications();
			DataRow dr1 = this._dtProdMods.NewRow();

			DataRow dr2 = tmpObj.LoadDataRowFromThis(dr1);

			Assert.AreEqual(dr1, dr2);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}

		[Test]
		public void IsProductModificationEnabled_Pass()
		{
			BOL.BloodProductModifications tmpObj = new BOL.BloodProductModifications();
			Assert.IsNotNull(tmpObj.IsProductModificationEnabled);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IsProductModificationEnabled_Fail()
		{
		}
	}
}
#endif






